import { BookOpen, Mail, Phone, MapPin, Clock, Facebook, Instagram, MessageCircle } from 'lucide-react'
import './Footer.css'

const Footer = () => {
  return (
    <footer className="footer-brutal">
      <div className="container">
        <div className="footer-content-brutal">
          <div className="footer-section-brutal">
            <div className="footer-logo-brutal">
              <div className="footer-logo-icon-wrapper-brutal">
                <BookOpen className="footer-logo-icon-brutal" size={28} />
              </div>
              <h2 className="footer-logo-text-brutal">CODEHUB</h2>
            </div>
            <p className="footer-description-brutal">
              Современная платформа для онлайн-обучения. 
              Качественные курсы с практическими заданиями и поддержкой преподавателей.
            </p>
            <div className="footer-social-brutal">
              <a href="#" className="social-link-brutal">
                <Instagram size={20} />
              </a>
              <a href="#" className="social-link-brutal">
                <Facebook size={20} />
              </a>
              <a href="#" className="social-link-brutal">
                <MessageCircle size={20} />
              </a>
            </div>
          </div>
          <div className="footer-section-brutal">
            <h3 className="footer-title-brutal">Навигация</h3>
            <ul className="footer-links-brutal">
              <li><a href="/">Мои заявки</a></li>
              <li><a href="/enroll">Записаться</a></li>
              <li><a href="#">О нас</a></li>
              <li><a href="#">Отзывы</a></li>
            </ul>
          </div>
          <div className="footer-section-brutal">
            <h3 className="footer-title-brutal">Контакты</h3>
            <ul className="footer-links-brutal">
              <li>
                <Phone size={16} />
                <a href="tel:+79991234567">+7 (999) 123-45-67</a>
              </li>
              <li>
                <Mail size={16} />
                <a href="mailto:info@codehub.ru">info@codehub.ru</a>
              </li>
              <li>
                <MapPin size={16} />
                <span>Москва, ул. Образовательная, 15</span>
              </li>
              <li>
                <Clock size={16} />
                <span>Пн-Пт: 9:00 - 21:00</span>
              </li>
            </ul>
          </div>
        </div>
        <div className="footer-bottom-brutal">
          <p>&copy; 2025 CODEHUB. Все права защищены.</p>
        </div>
      </div>
    </footer>
  )
}

export default Footer

